
alter table jin_role add priv_master_plugins_contseries int(1) not null default 0 after priv_master_plugins_metaaffs;

create table jin_content_series
(
  id             int(11) not null primary key,
  owner_id       int(11) not null,
  
  url            varchar(255) not null default '',
  title          varchar(255) not null default '',
  template       longtext not null default '',
  start_time     datetime null,
  membership_id  int(11) not null,
  loop_enabled   int(1) not null default 0,
  delay_for_n    varchar(10) not null default '',
  delay_for_u    char(1) not null default 0,
  
  key(owner_id,url)
);

create table jin_content_series_step
(
  id             int(11) not null primary key,
  owner_id       int(11) not null,
  series_id      int(11) not null default 0,
  
  display_for_n  varchar(10) not null default '',
  display_for_u  char(1) not null default 0,
  title        varchar(30) not null default '',
  content        longtext not null default '',
    
  key(owner_id, series_id)
);

# disable personal assistants
update jin_user set ownership_id=id;


alter table jin_role add priv_master_tools_dbbackup int(1) not null default 0 after priv_master_tools_apiuser;

create table jin_dbbackup
(
  id        int(11) not null primary key,
  owner_id  int(11) not null,
  
  enabled   int(1) not null default 0,
  period_u  char(1) not null default 0,
  ftp_serv  varchar(255) not null,
  ftp_user  varchar(255) not null,
  ftp_pass  varchar(255) not null,
  ftp_dir   varchar(255) not null,
  limit_backups  varchar(50) not null default '',
  
  key(owner_id)
);


create table jin_lesson_series
(
  id                 int(11) not null primary key,
  owner_id           int(11) not null,
  
  title              varchar(50) not null default '',
  template           longtext not null default '',
  
  email_welcome      text not null default '',
  email_next_lesson  text not null default '',
  email_farewell     text not null default '',
  
  key(owner_id)
);

create table jin_lesson
(
  id               int(11) not null primary key,
  owner_id         int(11) not null,
  
  series_id        int(11) not null,
  seq              int(3) not null,
  
  title            varchar(50) not null default '',
  
  display_for_l    int(11) not null default 0,
  display_for_u    varchar(10) not null default '',
  
  content          text not null default '',
  links            text not null default '',
  videos           varchar(255) not null default '',
  
  key(owner_id,series_id,seq)
);

create table jin_video
(
  id          int(11) not null primary key,
  owner_id    int(11) not null,
  
  title       varchar(50) not null default '',
  
  player      varchar(30) not null default '',
  youtube_id  varchar(30) not null default '',
  url         varchar(255) not null default '',
  
  key(owner_id)
);

alter table jin_role add priv_master_plugins_lessonman int(1) not null default 0 after priv_master_plugins_metaaffs;
alter table jin_product add dlv_lessonseries varchar(255) not null default '' after dlv_points;


alter table jin_role add priv_master_store_oneclickords int(1) not null default 0 after priv_master_store_products;

alter table jin_membership add email_renew text not null default '' after email_access;
alter table jin_membership add email_renew_period int(11) not null default 0 after email_renew;

alter table jin_package add reflink_disabled int(1) not null default 0 after notifysale_settings;

create table jin_reflink
(
  id            int(11) not null primary key,
  owner_id      int(11) not null,
  
  parent_id     int(11) not null default 0,
  
  introduction  text not null,
  url           varchar(255) not null default '',
  overridden    int(1) not null default 0,
  
  key(owner_id, parent_id)
);

create table jin_reflink_settings
(
  id                   int(11) not null primary key,
  owner_id             int(11) not null,
  
  limit_for_affiliate  int(11) not null default 0,
  limit_for_display    int(11) not null default 0,
  template             longtext not null default '',
    
  key(owner_id)
);

# normalize roles

delete from jin_role;
insert into jin_role set id=1,owner_id=1,title='Supervisor',priv_supervisor=1;
insert into jin_role set id=3,owner_id=1,title='Standard Customer and Affiliate',autoassign=1,priv_member_account_purchases=1,priv_member_account_mems=1,priv_member_account_jvmsubs=1,priv_member_account_points=1,priv_member_account_helptickets=1,priv_member_promote_affprogs=1,priv_member_promote_links=1,priv_member_promote_campaigns=1,priv_member_promote_commissions=1,priv_member_promote_jvproducts=1;

delete from jin_user_role where id=1;
insert into jin_user_role set id=1,owner_id=1,role_id=1,role_title='Supervisor',user_id=1;
update jin_user_role set role_id=3 where id!=1;