function dynamicAddrSetup(id1, id2)
{
	// id1 - country, id2 - state

	if (! document.getElementById || ! document.getElementsByTagName)
		return;

	var sel1 = document.getElementById(id1);
	var sel2 = document.getElementById(id2);

	var clone = sel2.cloneNode(true);
	var clonedOptions = clone.getElementsByTagName("option");

	dynamicAddrRefresh(sel1, sel2, clonedOptions);

	sel1.onchange = function()
	{
		dynamicAddrRefresh(sel1, sel2, clonedOptions);
		dynamicAddrOnChangeCountryState();
	}

	sel2.onchange = function()
	{
		dynamicAddrOnChangeCountryState();
	}
}

function dynamicAddrRefresh(sel1, sel2, clonedOptions)
{
	var sel2val = sel2.options[sel2.selectedIndex].value;	

	while (sel2.options.length)
	{
		sel2.remove(0);
	}

	var sel1val = sel1.options[sel1.selectedIndex].value;	
	
	var pattern = new RegExp("( |^)(" + sel1val + ")( |\$)");

	for (var i = 0; i < clonedOptions.length; i++)
	{
		if (
			! clonedOptions[i].className.length ||
			(! sel1val.length && clonedOptions[i].className == "HINT") ||
			clonedOptions[i].className.match(pattern)
		)
		{
			sel2.appendChild(clonedOptions[i].cloneNode(true));
		}
	}

	for (var i = 0; i < sel2.length; i++)
	{
		if (sel2.options[i].value == sel2val)
		{
			sel2.selectedIndex = i;
			break;
		}
	}
}

function dynamicAddrAddOnLoad(func)
{ 
	var oldonload = window.onload;
	if (typeof window.onload != 'function')
	{ 
		window.onload = func; 
	}
	else
	{ 
		window.onload = function()
		{
			if (oldonload)
				oldonload(); 
			func(); 
		}
	}
}

function dynamicAddrOnChangeCountryState()
{
	if (window.displayTaxInfo) displayTaxInfo();
	if (window.refreshDivShippingMethods) refreshDivShippingMethods();
}
